/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import it.unimi.dsi.fastutil.PriorityQueue;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ForkJoinWorkerThread;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pregenerator.ChunkPregenerator;
import pregenerator.PregenConfig;
import pregenerator.common.base.TaskStorage;
import pregenerator.common.generator.ChunkEntry;
import pregenerator.common.generator.ChunkLogger;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkUnloader;
import pregenerator.common.generator.GeneratorQueue;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.utils.collections.FIFOQueue;
import pregenerator.common.utils.misc.IntCounter;

public class ChunkProcessor
implements IProcess<ChunkProcess, ITask> {
    public static Logger LOGGER = LogManager.getLogger((String)"Pregen");
    IntCounter gen_speed = new IntCounter(20000);
    IntCounter light_speed = new IntCounter(20000);
    IntCounter timeout = new IntCounter(2400);
    IProcess.PrepaireProgress progress = null;
    ITask task;
    String taskName;
    ChunkProcess process = null;
    GeneratorQueue mainQueue = new GeneratorQueue(1000, 1, true, this::onMainPassFinished);
    GeneratorQueue lightQueue = new GeneratorQueue(750, 3, false, this::onLightPassFinished);
    ChunkUnloader unloader = new ChunkUnloader();
    FIFOQueue<ChunkEntry> chunksToLight = new FIFOQueue();
    Instant start;
    Duration terrainFinish = null;
    boolean multithreaded = false;
    long normalDone = 0L;
    long lightDone = 0L;
    long toLight = 0L;
    int ticker = 0;
    boolean unpaused = true;
    boolean prepaire = false;

    @Override
    public void prepaireTask(IProcess.PrepaireProgress progress, String taskName) {
        this.progress = progress;
        this.taskName = taskName;
        this.prepaire = true;
    }

    @Override
    public boolean startTask(ITask task, ChunkProcess process) {
        if (process == null || task == null || !this.prepaire || this.progress != null && !this.progress.isAlive()) {
            return false;
        }
        this.gen_speed.clear();
        this.light_speed.clear();
        this.chunksToLight.clear();
        this.timeout.clear();
        this.normalDone = 0L;
        this.lightDone = 0L;
        this.toLight = 0L;
        this.ticker = 0;
        this.task = task;
        this.process = process;
        this.start = Instant.now();
        this.unpaused = true;
        this.prepaire = false;
        this.progress = null;
        this.multithreaded = (Boolean)PregenConfig.INSTANCE.multithreaded.get();
        this.lightQueue.setActiveFiles(this.multithreaded ? 3 : 1);
        return true;
    }

    @Override
    public boolean isBlockingRetrogen() {
        return true;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    public ITask getTask() {
        return this.task;
    }

    @Override
    public boolean isRunning() {
        return this.unpaused;
    }

    @Override
    public void pauseTask() {
        if (this.process == null || !this.unpaused) {
            return;
        }
        this.unpaused = false;
    }

    @Override
    public void resumeTask() {
        if (this.process == null || this.unpaused) {
            return;
        }
        this.unpaused = true;
        this.timeout.clear();
    }

    @Override
    public void stopTask() {
        this.prepaire = false;
        if (this.process == null) {
            return;
        }
        TaskStorage.getGenStorage().stopTask(this.getTaskName());
        this.process.interrupt();
        this.mainQueue.interrupt();
        this.lightQueue.interrupt();
        this.unloader.forceFinish(this.process);
        this.chunksToLight.clear();
        this.process = null;
        this.task = null;
        if (this.progress != null) {
            this.progress.interruptTask();
        }
        this.progress = null;
    }

    @Override
    public void onTickStart() {
        if (this.progress != null && this.ticker++ % 20 == 0) {
            if (!this.progress.isAlive()) {
                this.stopTask();
                return;
            }
            long value = this.progress.getValue();
            long max = this.progress.getMax();
            double progress = (double)value / (double)max * 100.0;
            ServerManager.INSTANCE.listen((Component)new TextComponent("Prepaire Progress: " + FORMAT.format(value) + " / " + FORMAT.format(max) + " [" + ItemStack.f_41584_.format(progress) + "%]").m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    public void onTickStop(boolean paused) {
        if (this.process == null) {
            return;
        }
        if (paused) {
            return;
        }
        this.toLight += this.unloader.process((PriorityQueue<ChunkEntry>)this.chunksToLight);
        this.process.onTick();
        if (this.unpaused) {
            if (this.multithreaded) {
                this.process.drainIntoQueue(this.mainQueue);
                while (!this.chunksToLight.isEmpty() && this.lightQueue.enqueue((ChunkEntry)this.chunksToLight.first())) {
                    this.toLight -= (long)((ChunkEntry)this.chunksToLight.dequeue()).getTotalSize();
                }
            } else {
                this.process.drainIntoQueue(this.lightQueue);
            }
        }
        this.mainQueue.tick();
        this.lightQueue.tick();
        this.gen_speed.setNewValue(this.normalDone + (long)this.mainQueue.getSubProgress());
        if (this.lightDone > 0L || this.lightQueue.getSubProgress() > 0) {
            this.light_speed.setNewValue(this.lightDone + (long)this.lightQueue.getSubProgress());
        }
        if (this.ticker++ % 20 == 0 && this.unpaused) {
            TextComponent text = new TextComponent("\n");
            for (ChunkLogger logger : ChunkLogger.values()) {
                logger.append((MutableComponent)text, this);
                if (logger == ChunkLogger.RamUsage) continue;
                text.m_130946_("\n");
            }
            ServerManager.INSTANCE.listen((Component)text);
            if (!this.mainQueue.isNotWorking() && this.timeout.isFull() && this.timeout.getTotalValue() <= 0.0f) {
                this.printThreadPool();
                this.mainQueue.attemptUnstucking();
                this.timeout.clear();
            }
        }
        this.process.getProvider().m_7827_().m_9409_();
        if (this.process.isDone() && this.mainQueue.isNotWorking() && this.lightQueue.isNotWorking() && this.unloader.isFinished() && this.unpaused) {
            this.onTaskFinished();
        }
    }

    public void printThreadPool() {
        TextComponent component = new TextComponent("WorldGenerator didn't generate any Chunks for 2 Minutes It seems to be stuck. Dumping Thread Trace \n");
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            Thread thread = entry.getKey();
            if (!(thread instanceof ForkJoinWorkerThread) || ((ForkJoinWorkerThread)thread).getPool() != Util.m_183991_()) continue;
            TextComponent threadData = new TextComponent("Thread: " + thread.getName() + ", StackTrace: \n");
            for (StackTraceElement element : entry.getValue()) {
                threadData.m_130946_(element.toString()).m_130946_("\n");
            }
            component.m_7220_((Component)threadData);
        }
        ChunkPregenerator.LOGGER.info(component.getString());
    }

    public StringBuilder getRam(StringBuilder builder) {
        long j = Runtime.getRuntime().totalMemory();
        return builder.append(this.toMB(j - Runtime.getRuntime().freeMemory())).append(" MB / ").append(this.toMB(Runtime.getRuntime().maxMemory())).append(" MB, Allocated=").append(this.toMB(j)).append(" MB");
    }

    protected long toMB(long base) {
        return base / 1024L / 1024L;
    }

    protected void onTaskFinished() {
        ServerManager.INSTANCE.listen((Component)new TextComponent("Pregenerator Finished. Starting Cleanup! May freeze the game!"));
        this.process.getProvider().m_8419_(false);
        ServerManager.INSTANCE.listen((Component)new TextComponent("Pregenation Finished: [Time=" + this.getTime() + ", Chunks=" + this.process.getTotalChunks() + "]"));
        Duration time = Duration.between(Instant.now(), this.start).abs();
        long total = this.process.getTotalChunks();
        this.process.onTaskFinished();
        this.process = null;
        this.task.onCompletion(this.terrainFinish == null ? time : this.terrainFinish, time, total);
        TaskStorage.getGenStorage().removeTask(this.task.getName());
        ServerManager.INSTANCE.onTaskFinished(this.task.getDimension());
        this.task = null;
    }

    protected void onMainPassFinished(ChunkEntry file) {
        this.normalDone += (long)file.getTotalSize();
        if (this.process.isDone() && this.mainQueue.isNotWorking()) {
            this.terrainFinish = Duration.between(Instant.now(), this.start).abs();
        }
        if (file.isUnloaded()) {
            this.lightDone += (long)file.getTotalSize();
            return;
        }
        if (this.unpaused && !file.isTaskFinished() && this.lightQueue.isNotWorking() && this.lightQueue.enqueue(file)) {
            return;
        }
        if (file.isSkipped()) {
            file.removeSkip();
            this.chunksToLight.enqueue(file);
            this.toLight += (long)file.getTotalSize();
            return;
        }
        this.unloader.enqueue(file);
    }

    protected void onLightPassFinished(ChunkEntry file) {
        this.lightDone += (long)file.getTotalSize();
        this.unloader.enqueue(file);
    }

    protected String getTime() {
        return DurationFormatUtils.formatDuration((long)Duration.between(Instant.now(), this.start).abs().toMillis(), (String)"HH:mm:ss");
    }

    public long getTotal() {
        return this.process != null ? this.process.getTotalChunks() : 0L;
    }

    public long getGenDone() {
        return this.multithreaded ? this.gen_speed.getLastValue() : this.light_speed.getLastValue();
    }

    public long getLightDone() {
        return this.light_speed.getLastValue();
    }

    @Override
    public void sendClientData(FriendlyByteBuf buffer) {
        buffer.writeByte(1);
        buffer.writeBoolean(this.prepaire || this.task == null);
        buffer.m_130070_(this.taskName);
        Runtime runtime = Runtime.getRuntime();
        buffer.writeLong(runtime.totalMemory());
        buffer.writeLong(runtime.maxMemory());
        buffer.writeLong(runtime.freeMemory());
        if (this.prepaire || this.task == null) {
            buffer.writeLong(this.progress == null ? 0L : this.progress.getValue());
            buffer.writeLong(this.progress == null ? 0L : this.progress.getMax());
            return;
        }
        buffer.writeBoolean(this.unpaused);
        buffer.writeLong(Duration.between(this.start, Instant.now()).toMillis());
        buffer.writeLong(this.process.getTotalChunks());
        buffer.writeLong(this.multithreaded ? this.gen_speed.getLastValue() : this.light_speed.getLastValue());
        buffer.writeLong(this.light_speed.getLastValue());
        buffer.writeFloat(this.light_speed.getTotalValue());
        buffer.writeFloat(this.multithreaded ? this.gen_speed.getTotalValue() : this.light_speed.getTotalValue());
        buffer.writeInt(this.process.getPointsOfInterest());
        buffer.writeInt(this.process.getLoadedChunks());
        buffer.writeLong(this.toLight);
        buffer.writeInt(this.unloader.getChunksToUnload());
        buffer.m_130079_(ITask.saveTask(this.task));
    }
}

